#pragma     pack(2)
#include <PalmOS.h>
#include <System/DataMgr.h>
#include <System/MemoryMgr.h>
#include 	"fh2.h"
#include	"fh2common.h"

static int StartApplication(void);
static void EventLoop(void);
static void StopApplication(void);
static Boolean frmMainEH(EventPtr event);

MemPtr GetMem(MemPtr oldptr,UInt32 size);

typedef struct tagGlobalData{
	AppData *appData;
	FontEntry *fontData;
	char **appList, **fontList;
	UInt16 fontCount, appCount, appCurrent;
	UInt32 version;
}GlobalData;

void CreateAppList(GlobalData *gd);
void SaveAppList(GlobalData *gd);
void CreateFontList(GlobalData *gd);
void ReleaseFontList(GlobalData *gd);
void SetLists(GlobalData *gd,FormPtr form);
void UpdateTriggers(GlobalData *gd,FormPtr form);
void CheckFontDataValidity(GlobalData *gd);

Int16 comparFapp(void * p1, void *p2, Int32 other);
Int16 comparFfont(void * p1, void *p2, Int32 other);

GlobalData *CreateGD();
GlobalData *GetGD();
void ReleaseGD(GlobalData* gd);

__asm("bra frmMainEH");

GlobalData *CreateGD()
{
	GlobalData *gd=GetMem(NULL,sizeof(GlobalData));
	MemSet((MemPtr)gd,sizeof(GlobalData),0);
	FtrSet(CRID,ftrGlobalData,(UInt32)gd);
	return gd;
}

GlobalData *GetGD()
{
	GlobalData *gd;
	if(FtrGet(CRID,ftrGlobalData,(UInt32 *)&gd)!=0)
		ErrFatalDisplay("Not enough memory");
	return gd;
}

void ReleaseGD(GlobalData* gd)
{
	MemPtrFree(gd); // would complain by itself, no need to help =-))
	FtrUnregister(CRID,ftrGlobalData);
}

Int16 comparFapp(void * p1, void *p2, Int32 other)
{
	return StrCompare(((AppData *)p1)->name,((AppData *)p2)->name);
}

Int16 comparFfont(void * p1, void *p2, Int32 other)
{
	return StrCompare(((FontEntry *)p1)->name,((FontEntry *)p2)->name);
}

void ListDrawFunc (Int16 itemNum, RectangleType *bounds, Char **itemsText)
{
GlobalData *gd=GetGD();
MemHandle vh;
DmOpenRef dbref=0;
MemPtr ptr=NULL;
FontID fid;
Int16 width, length, numFonts;
Boolean chop=false;

	if(itemNum>gd->fontCount || gd==NULL || gd->fontData==NULL) return;
	numFonts=(gd->version<0x03000000l)?7:8;

	fid=FntGetFont();
	
	if(gd->fontData[itemNum].dbID==0){
		if(gd->fontData[itemNum].index>0 && gd->fontData[itemNum].index<=numFonts)
			FntSetFont(gd->fontData[itemNum].index-1);
		else
			FntSetFont(2); // should never happen		
	}else{
		dbref=DmOpenDatabase(gd->fontData[itemNum].cardNo,gd->fontData[itemNum].dbID,dmModeReadOnly);
		if(dbref){
			if(vh=DmQueryRecord(dbref,gd->fontData[itemNum].index)){
				ptr=MemHandleLock(vh);
				if(gd->version<0x03000000l){
					*((UInt32 *)0x1ce)=(UInt32)ptr;
				}else{
					*((UInt32 *)0x1d6)=(UInt32)ptr;
				}
			}
			DmCloseDatabase(dbref);
		}
	}
	
	length=StrLen(itemsText[itemNum]);
	width=bounds->extent.x;
	FntCharsInWidth(itemsText[itemNum],&width,&length,&chop);
	
	WinDrawChars(itemsText[itemNum],length,bounds->topLeft.x,bounds->topLeft.y);
	
	FntSetFont(fid);
	if(ptr!=NULL)
		MemHandleUnlock(vh);	
}

void CreateAppList(GlobalData *gd)
{
DmOpenRef dbref;
MemHandle vh;
AppData *oldAppData=NULL;
UInt16 oldAppCount=0;
//
DmSearchStateType dmss;
Err result;
UInt16 cardNo,i;
LocalID dbID;
char name[dmDBNameLength+1];
UInt16 *uiptr;

	// obtain old appdata db
	dbref=DmOpenDatabaseByTypeCreator(DBTYPE,CRID,dmModeReadOnly);
	if(dbref){
		if(vh=DmQueryRecord(dbref,0)){
			uiptr=(UInt16 *)MemHandleLock(vh);
			if(uiptr){
				oldAppCount=*uiptr;
				oldAppData=(AppData*)&(uiptr[1]);
			}
		}
		DmCloseDatabase(dbref);
	}

	// create 1st appdata entry for All Apps and copy old values if any
	gd->appData=GetMem(NULL,sizeof(AppData));
	MemSet((MemPtr)&(gd->appData[0]),sizeof(AppData),0);
	if(oldAppData)
		MemMove((MemPtr)&(gd->appData[0]),(MemPtr)&(oldAppData[0]),sizeof(AppData));
	gd->appData[0].name=GetMem(NULL,StrLen("All apps")+1);
	StrCopy(gd->appData[0].name,"All apps");
	gd->appCount=1;

	// go through all dbs
	for(result=DmGetNextDatabaseByTypeCreator(true,&dmss,'appl',0,false,&cardNo,&dbID);
		result==0;
		result=DmGetNextDatabaseByTypeCreator(false,&dmss,'appl',0,false,&cardNo,&dbID)){

		// add app data entry
		gd->appData=GetMem(gd->appData,sizeof(AppData)*(gd->appCount+1));
		MemSet((MemPtr)&(gd->appData[gd->appCount]),sizeof(AppData),0);
		
		// copy old font values if any
		for(i=0;i<oldAppCount;i++){
			if((oldAppData[i].cardNo==cardNo) && (oldAppData[i].dbID==dbID)){
				MemMove((MemPtr)&(gd->appData[gd->appCount].fonts[0]),(MemPtr)&(oldAppData[i].fonts[0]),sizeof(FontEntry)*MAXFONTS);
				break;
			}
		}

		// add app name to data entry
		DmDatabaseInfo(cardNo,dbID,name,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
		gd->appData[gd->appCount].name=GetMem(NULL,StrLen(name)+1);
		StrCopy(gd->appData[gd->appCount].name,name);

		// set app data db and card
		gd->appData[gd->appCount].cardNo=cardNo;
		gd->appData[gd->appCount].dbID=dbID;
		gd->appCount++;
	}
	
	// sort
	if(gd->appCount>2)
		SysQSort(&gd->appData[1],gd->appCount-1,sizeof(AppData),comparFapp,0);

	// create app list
	gd->appList=GetMem(NULL,sizeof(char*)*gd->appCount);
	for(i=0;i<gd->appCount;i++)
		gd->appList[i]=gd->appData[i].name;

	// unlock old app data ptr
	if(oldAppData)
		MemHandleUnlock(vh);
}

void SaveAppList(GlobalData *gd)
{
UInt16 i;
LocalID dbID;
DmOpenRef dbref;
MemHandle vh;
MemPtr ptr;
Boolean success=false;

	if(gd->appList!=NULL){
		MemPtrFree(gd->appList);
		gd->appList=NULL;
	}

	// save appdata
	if(gd->appData!=NULL){

		// free list of names
		for(i=0;i<gd->appCount;i++){
			MemPtrFree(gd->appData[i].name);
			gd->appData[i].name=NULL;
		}
	
		// delete previous
		if(dbID=DmFindDatabase(0,DBNAME))
			DmDeleteDatabase(0,dbID);
			
		// Create new
		DmCreateDatabase(0,DBNAME,CRID,DBTYPE,false);
		dbref=DmOpenDatabaseByTypeCreator(DBTYPE,CRID,dmModeWrite);
		if(dbref){
			i=0;
			vh=DmNewRecord(dbref,&i,sizeof(AppData)*gd->appCount+sizeof(UInt16));
			if(vh){
				ptr=MemHandleLock(vh);
				if(ptr){
					if(DmWrite(ptr,0,&(gd->appCount),sizeof(UInt16))==0 
						&& DmWrite(ptr,sizeof(UInt16),gd->appData,sizeof(AppData)*(gd->appCount))==0){
						success=true;
					}
					MemHandleUnlock(vh);
				}
				DmReleaseRecord(dbref,i,true);
			}
			DmCloseDatabase(dbref);
		}
		
		// free & null appdata
		MemPtrFree(gd->appData);
		gd->appData=NULL;
	}
	
	gd->appCount=0; // zero appcount just in case
	
	if(!success){
		FrmAlert(frmCouldNotSave);
	}
}

void CreateFontList(GlobalData *gd)
{
DmSearchStateType dmss;
Err result;
UInt16 cardNo,i,dbattr;
UInt32 numRec;
LocalID dbID;
char name[dmDBNameLength+1];
char buf1[50+dmDBNameLength+1],buf[10];
UInt16 *wchunk;
DmOpenRef dbref;
MemHandle vh;
char *fontnames[MAXFONTS+1]={"none","Standard","Bold","Large","Symbol","Symbol11","Symbol7","LED","LargeBold"};

	// create fontdata ptr and set "none" value
	gd->fontData=GetMem(NULL,sizeof(FontEntry)*(MAXFONTS+1));
	MemSet((MemPtr)&(gd->fontData[0]),sizeof(FontEntry)*(MAXFONTS+1),0);
	for(i=0;i<MAXFONTS+1;i++){
		gd->fontData[i].name=GetMem(NULL,StrLen(fontnames[i])+1);
		StrCopy(gd->fontData[i].name,fontnames[i]);
		gd->fontData[i].index=i;
	}
	gd->fontCount=MAXFONTS+1;


	// go through font dbs
	for(result=DmGetNextDatabaseByTypeCreator(true,&dmss,'Font',0,false,&cardNo,&dbID);
			result==0;
		result=DmGetNextDatabaseByTypeCreator(false,&dmss,'Font',0,false,&cardNo,&dbID)){

		DmDatabaseInfo(cardNo,dbID,name,&dbattr,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
		if(dbattr&dmHdrAttrResDB)
			continue;
		dbref=DmOpenDatabase(cardNo,dbID,dmModeReadOnly);
		numRec=0;

		// for each record
		DmDatabaseSize(cardNo,dbID,&numRec,NULL,NULL);
		for(i=0;i<numRec;i++){
			vh=DmQueryRecord(dbref,i);
			if(!vh)continue;
			wchunk=MemHandleLock(vh);
			if(*wchunk==0x9000){
				StrCopy(buf1,name);
				StrCat(buf1," (");
				StrIToA(buf,i);
				StrCat(buf1,buf);
				StrCat(buf1,")");
								
				// set font data & list
				gd->fontData=GetMem(gd->fontData,sizeof(FontEntry)*(gd->fontCount+1));
				gd->fontData[gd->fontCount].cardNo=cardNo;
				gd->fontData[gd->fontCount].dbID=dbID;
				gd->fontData[gd->fontCount].index=i;
				gd->fontData[gd->fontCount].name=GetMem(NULL,StrLen(buf1)+1);
				StrCopy(gd->fontData[gd->fontCount].name,buf1);
				
				gd->fontCount++;
			}
			MemHandleUnlock(vh);
		}
		DmCloseDatabase(dbref);
	}

	if(gd->fontCount>MAXFONTS+1+2)
		SysQSort(&gd->fontData[MAXFONTS+1],gd->fontCount-(MAXFONTS+1),sizeof(FontEntry),comparFfont,0);

	// create app list
	gd->fontList=GetMem(NULL,sizeof(char*)*gd->fontCount);
	for(i=0;i<gd->fontCount;i++)
		gd->fontList[i]=gd->fontData[i].name;
}

void ReleaseFontList(GlobalData *gd)
{
UInt16 i;
	if(gd->fontList!=NULL){
		MemPtrFree(gd->fontList);
		gd->fontList=NULL;
	}
	if(gd->fontData!=NULL){
		for(i=0;i<gd->fontCount;i++)
			MemPtrFree(gd->fontData[i].name);
		MemPtrFree(gd->fontData);
		gd->fontData=NULL;
	}
	gd->fontCount=0;
}

void SetLists(GlobalData *gd, FormPtr form)
{
UInt16 i;
ListType *lp;
	if(gd->appList!=NULL)
		LstSetListChoices(FrmGetObjectPtr(form,FrmGetObjectIndex(form,liApplication)),gd->appList,gd->appCount);
	if(gd->fontList!=NULL)
		for(i=0;i<MAXFONTS;i++){
			lp=FrmGetObjectPtr(form,FrmGetObjectIndex(form,liStandard+i));	
			LstSetListChoices(lp,gd->fontList,gd->fontCount);
			LstSetDrawFunction(lp, ListDrawFunc);
		}
	UpdateTriggers(gd,form);
}

void UpdateTriggers(GlobalData *gd, FormPtr form)
{
UInt16 i,j,index;
	if(gd->appData==NULL || gd->fontData==NULL || gd->fontList==NULL) return;
	for(i=0;i<MAXFONTS;i++){
		index=0;
		for(j=0;j<gd->fontCount;j++){
			if(gd->appData[gd->appCurrent].fonts[i].dbID==gd->fontData[j].dbID 
				&& gd->appData[gd->appCurrent].fonts[i].cardNo==gd->fontData[j].cardNo 
				&& gd->appData[gd->appCurrent].fonts[i].index==gd->fontData[j].index)
				index=j;
		}
		LstSetSelection(FrmGetObjectPtr(form,FrmGetObjectIndex(form,liStandard+i)),index);
		CtlSetLabel(FrmGetObjectPtr(form,FrmGetObjectIndex(form,pStandard+i)),gd->fontList[index]);
	}
}

void ResetAppData(GlobalData *gd)
{
UInt16 i,j;
FormPtr form;
	if(gd->appData==NULL) return;
	if(FrmAlert(frmConfirmReset)!=0) return;
	for(i=0;i<gd->appCount;i++){
		for(j=0;j<MAXFONTS;j++){
			gd->appData[i].fonts[j].dbID=0;
			gd->appData[i].fonts[j].cardNo=0;
			gd->appData[i].fonts[j].index=0;
		}
	}
	form=FrmGetActiveForm();
	if(form)
		UpdateTriggers(gd,form);
}

void CheckFontDataValidity(GlobalData *gd)
{
UInt16 i,j,k;
Boolean found;

	if(gd->appData==NULL || gd->fontData==NULL) return;

	for(i=0;i<gd->appCount;i++){
		for(j=0;j<MAXFONTS;j++){
			if(gd->appData[i].fonts[j].dbID!=0){
				found=false;
				for(k=0;k<gd->fontCount;k++){
					if(gd->appData[i].fonts[j].dbID==gd->fontData[k].dbID
						&& gd->appData[i].fonts[j].cardNo==gd->fontData[k].cardNo
						&& gd->appData[i].fonts[j].index==gd->fontData[k].index){
			
						found=true;
						break;
					}
				}
				if(!found){
					gd->appData[i].fonts[j].dbID=0;
					gd->appData[i].fonts[j].cardNo=0;
					gd->appData[i].fonts[j].index=0;
				}
			}
		}
	}
}

static Boolean frmMainEH(EventPtr event)
{
	FormPtr   form;
	int       handled = 0;
	GlobalData *gd;
	UInt32 version;

	switch (event->eType)
	{
		case frmOpenEvent:
			form = FrmGetActiveForm();
			version=0;
			FtrGet(sysFtrCreator,sysFtrNumROMVersion,&version);
			if(version<0x03000000l)
				FrmHideObject(form,FrmGetObjectIndex(form,pLargeBold));
			if((version&0x0FF00000l) > 0x04000000l){
				FrmAlert(frmUnknownOS);
				FrmGotoForm(9000);
				return true;
			}
			gd=CreateGD();
			gd->appCurrent=0;
			gd->version=version;
			CreateAppList(gd);
			CreateFontList(gd);
			CheckFontDataValidity(gd);
			SetLists(gd,form);
			FrmDrawForm(form);
//			FrmDoDialog(FrmInitForm(frmAbout));
			handled = 1;
		break;
		case ctlSelectEvent:  // A control button was pressed and released.
			switch (event->data.ctlEnter.controlID){
			case bReset:
				gd=GetGD();
				ResetAppData(gd);
				handled = 1;
				break;
			case bSave:
				gd=GetGD();
				SaveAppList(gd);
				ReleaseFontList(gd);
				ReleaseGD(gd);
				FrmAlert(frmFontSizeWarning);
				FrmGotoForm(9000);
				handled = 1;
				break;
			}
		break;
		case popSelectEvent:
			gd=GetGD();
			if(event->data.popSelect.listID==liApplication){
				form = FrmGetActiveForm();
				gd->appCurrent=event->data.popSelect.selection;
				UpdateTriggers(gd,form);
			}else{
				if(gd->appData!=NULL && gd->fontData!=NULL)
					MemMove((MemPtr)&(gd->appData[gd->appCurrent].fonts[event->data.popSelect.listID-liStandard]),
						(MemPtr)&(gd->fontData[event->data.popSelect.selection]),sizeof(FontEntry));
			}
		break;
		case nilEvent:
			handled = 1;
		break;
	}
	return handled;
}

MemPtr GetMem(MemPtr oldptr,UInt32 size)
{
MemPtr ptr;
	ptr=MemPtrNew(size);
	if(ptr!=NULL){
		if(oldptr!=NULL){
			MemMove(ptr,oldptr,MemPtrSize(oldptr));
			MemPtrFree(oldptr);
		}
		return ptr;
	}
	ErrFatalDisplay("Not enough memory");
	return NULL; // ??? Reset
}
