#pragma pack(2)
#include <PalmOS.h>
#include <System/DataMgr.h>
#include <System/MemoryMgr.h>
#include <System/SystemMgr.h>
#include "fh2.h"
#include "fh2common.h"

typedef struct appFontInfoTag{
	char appName[dmDBNameLength];
	MemHandle fontHand[8];
} appFontInfo;

Boolean SetStandardFont(UInt16 index, UInt16 srcindex, UInt32 version);
Boolean SetCustomFont(UInt16 index, MemPtr ptr, UInt32 version);
void SetResetLockFont(UInt16 index, FontEntry *rec, UInt32 version);
Boolean IsHackMaster(UInt16 cardNo, LocalID dbID);
Err MySysAppStartup(SysAppInfoPtr* appInfoPP, MemPtr* prevGlobalsP, MemPtr* globalsPtrP);
UInt32 CheckAppData();
Boolean FontDBExists(UInt16 cardNo, LocalID dbID);

__asm("bra MySysAppStartup"); // to skip constants definitions in text segment

Err MySysAppStartup(SysAppInfoPtr* appInfoPP, MemPtr* prevGlobalsP, MemPtr* globalsPtrP)
{
Err (*oldtrap) (SysAppInfoPtr* appInfoPP, MemPtr* prevGlobalsP, MemPtr* globalsPtrP);
Err retval;
UInt32 version=0,configOK;
MemHandle vh;
UInt16 i,numFonts,j;
UInt16 *uiptr=NULL;
//
DmOpenRef dbref;
AppData *appData=NULL;
AppData *thisAppData;
UInt16 appCount=0;
//
LocalID dbID=0;
UInt16 cardNo=0;
FontEntry *rec;
Boolean HackMaster;

	// get oldtrap, check if normal launch, otherwise exit
	FtrGet(CRID,ftrTrapStart,(UInt32*)&oldtrap);
	retval=(*oldtrap)(appInfoPP,prevGlobalsP,globalsPtrP);
	
	if((*appInfoPP)->cmd!=sysAppLaunchCmdNormalLaunch)
		return retval;
		
	// if < PalmOS 3.0, disable BigBold font setting
	FtrGet(sysFtrCreator,sysFtrNumROMVersion,&version);
	numFonts=(version<0x03000000l)?7:8;

	// unlock previous fonts, if any
	for(i=0;i<numFonts;i++){
		if(FtrGet(CRID,ftrLockedFonts+i,(UInt32 *)&vh)==0){
			MemHandleUnlock(vh);
			FtrUnregister(CRID,ftrLockedFonts+i);
		}	
	}
	
	// get current dbid
	SysCurAppDatabase(&cardNo, &dbID); // if unable to get, it would take "all"
	
	// check if HackMaster, EVPlugBase, X-Master or TealMaster
	HackMaster=IsHackMaster(cardNo, dbID);
	if(HackMaster){
		FtrUnregister(CRID,ftrConfigOK);
		configOK=1; // it will set system fonts anyway
	}else{
		if(FtrGet(CRID,ftrConfigOK,&configOK)){ // unable to get
			configOK=CheckAppData();
		}
	}

	// throw towel if OS > 4.0
	if((version&0x0FF00000l) > 0x04000000l)
		return retval;

	if(!configOK)
		return retval;

	// load appinfo
	dbref=DmOpenDatabaseByTypeCreator(DBTYPE,CRID,dmModeReadOnly);
	if(dbref){
		if(vh=DmQueryRecord(dbref,0)){
			uiptr=(UInt16 *)MemHandleLock(vh);
			if(uiptr){
				appCount=*uiptr;
				appData=(AppData*)&(uiptr[1]);
			}
		}
		DmCloseDatabase(dbref);
	}

	// find this app's data record
	thisAppData=NULL;
	for(i=0;i<appCount;i++){
		if(appData[i].dbID==dbID && appData[i].cardNo==cardNo){
			thisAppData=&appData[i];
			break;
		}
	}

	// check for specific data
	for(j=0;j<numFonts;j++){

		rec=NULL;
		if(thisAppData)
			rec=&(thisAppData->fonts[j]);

		// combine with "all" data
		if((rec==NULL || (rec->dbID==0 && rec->index==0) ) && (appData[0].fonts[j].dbID!=0 || appData[0].fonts[j].index>0) )
			rec=&(appData[0].fonts[j]);

		// if HackMaster - set standard fonts everywhere
		if(HackMaster) rec=NULL;

		// lock, set fonts, save them into ftrs		
		SetResetLockFont(j,rec,version);
	}

	if(uiptr)
		MemHandleUnlock(vh);

	return retval;
}

UInt32 CheckAppData()
{
DmOpenRef dbref;
AppData *appData=NULL;
UInt16 appCount=0,i,j;
MemHandle vh;
UInt32 configOK=1;
UInt16 *uiptr=NULL;

	dbref=DmOpenDatabaseByTypeCreator(DBTYPE,CRID,dmModeReadOnly);
	if(dbref){
		if(vh=DmQueryRecord(dbref,0)){
			uiptr=(UInt16 *)MemHandleLock(vh);
			if(uiptr){
				appCount=*uiptr;
				appData=(AppData*)&(uiptr[1]);
				for(i=0;i<appCount && configOK;i++){
					for(j=0;j<MAXFONTS && configOK;j++){
						if(appData[i].fonts[j].dbID){
							if(!FontDBExists(appData[i].fonts[j].cardNo,appData[i].fonts[j].dbID))
								configOK=0;
						}
					}
				}
				MemHandleUnlock(vh);
			}
		}
		DmCloseDatabase(dbref);
	}
	
	if(!configOK){
		dbref=DmOpenDatabaseByTypeCreator('HACK',CRID,dmModeReadOnly);
		if(dbref){
			FrmAlert(frmReconfigure);
			DmCloseDatabase(dbref);
		}
	}
	
	FtrSet(CRID,ftrConfigOK,configOK);
	return configOK;
}

Boolean FontDBExists(UInt16 cardNo, LocalID dbID)
{
UInt16 dbattr;
UInt32 type;
LocalID tmpdbID;
UInt16 i=0;

	while(tmpdbID=DmGetDatabase(cardNo,i++)){
		if(tmpdbID==dbID){
			dbattr=0xFFFF;
			type=0;
			DmDatabaseInfo(cardNo,dbID,NULL,&dbattr,NULL,NULL,NULL,NULL,NULL,NULL,NULL,&type,NULL);
			if( (dbattr&dmHdrAttrResDB)==0 && type=='Font' )
				return true;
		}
	}
	return false;
}

Boolean IsHackMaster(UInt16 cardNo, LocalID dbID)
{
UInt32 crid=0;
char name[dmDBNameLength+1];
	DmDatabaseInfo(cardNo, dbID, name,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,&crid);
	if((crid=='dwHM' && StrCompare(name,"HackMaster")==0)
		||(crid=='evPB' && StrCompare(name,"EVPlugBase")==0)
		||(crid=='TlMs' && StrCompare(name,"TealMaster")==0)
		||(crid=='ExtM' && StrCompare(name,"X-Master")==0))
		return true;
	return false;
}

void SetResetLockFont(UInt16 index, FontEntry *rec, UInt32 version)
{
DmOpenRef dbref=0;
MemHandle vh;
MemPtr ptr;
	
	if(rec==NULL){
		SetStandardFont(index,index,version);
		return;
	}
		
	if(rec->dbID==0 && rec->cardNo==0 && rec->index>0){
		SetStandardFont(index,rec->index-1,version);
		return;
	}

	if(rec->dbID!=0){
		dbref=DmOpenDatabase(rec->cardNo,rec->dbID,dmModeReadOnly);
		if(dbref){
			vh=DmQueryRecord(dbref,rec->index);
			if(vh){
				ptr=MemHandleLock(vh); // record is not unlocked here
				if(ptr){
					SetCustomFont(index,ptr,version);
					FtrSet(CRID,ftrLockedFonts+index,(UInt32)vh);
					DmCloseDatabase(dbref);
					return;
				}
			}
			DmCloseDatabase(dbref);
		}
	}
	SetStandardFont(index,index,version);
}

Boolean SetStandardFont(UInt16 index, UInt16 srcindex, UInt32 version)
{
MemHandle fh;
MemPtr ptr;
UInt16 OS4fonts[MAXFONTS]={0x7d00,0x7d01,0x7d02,0x2710,0x2711,0x2712,0x2713,0x07d03};
UInt16 resindex;

	if(version<0x04000000l)
		resindex=0x2328+srcindex;
	else
		resindex=OS4fonts[srcindex];

	if(fh=DmGetResource('NFNT',resindex)){
		ptr=MemHandleLock(fh);
		SetCustomFont(index,ptr,version);
		MemHandleUnlock(fh);
		DmReleaseResource(fh);
	}
	return true;
}

Boolean SetCustomFont(UInt16 index, MemPtr ptr, UInt32 version)
{
	if(ptr==NULL)
		return true;

	if(index>7 || (version<0x03000000l&&index>6) )
		index=0;

	if(version<0x03000000l)
		*(((UInt32 *)0x1d2)+index)=(UInt32)ptr;
	else
		*((*((UInt32 **)0x1da))+index)=(UInt32)ptr;

	return true;
}
